setwd('./home/rstudio/')

library(dplyr)
library(Seurat)
library(ggplot2)
library(patchwork)

# seurat_object <- readRDS('<PATH_TO_OBJECT>')
seurat_object <- Prrx1.periosteum

# Plot UMAPs
png(paste0("UMAP.png"), width=15, height=15, units = 'cm', res = 400)
DimPlot(seurat_object)
graphics.off()

png(paste0("UMAP_facet.png"), width=45, height=15, units = 'cm', res = 400)
DimPlot(seurat_object, split.by = 'Age')
graphics.off()

# the two filtering parameters seurat_clusters and stage may need to change depending on what columnn the column names are in your seurat meta.data
# you can check/change this by looking at colnames(seurat_object@meta.data)

# Get cell IDs to subset downstream
selected_cells_young <- seurat_object@meta.data %>% filter(seurat_clusters %in% c(0,1)) %>% filter(Age_Diet == 'Young_AL') %>% rownames()
selected_cells_aged <- seurat_object@meta.data %>% filter(seurat_clusters %in% c(0,1)) %>% filter(Age == 'Aged') %>% rownames()


# Subset selected cells from Seurat objects for plotting UMAPs
min_y = -12.5
max_y = 6
min_x = -11
max_x = 6

dimplot <- DimPlot(seurat_object) + ylim(min_y, max_y) + xlim(min_x, max_x) + ggtitle("Clusters")

selected_cells_young_umap <- subset(seurat_object, cells = selected_cells_young) %>%
        DimPlot() + ylim(min_y, max_y) + xlim(min_x, max_x) + ggtitle("Selected cells Young (clusters 0 and 1)")

selected_cells_aged_umap <- subset(seurat_object, cells = selected_cells_aged) %>%
        DimPlot() + ylim(min_y, max_y) + xlim(min_x, max_x) + ggtitle("Selected cells Aged (clusters 0 and 1)")

png(paste0("UMAP_subset.png"), width=45, height=15, units = 'cm', res = 400)
dimplot + selected_cells_young_umap + selected_cells_aged_umap
graphics.off()

# Calculate and save DE genes
dea <- FindMarkers(seurat_object, ident.1 = selected_cells_young, ident.2 = selected_cells_aged)
write.csv(dea, file = 'dea.csv', row.names=TRUE, quote=FALSE)



# JR code
Idents(Prrx1.periosteum) <- "seurat_clusters" 
u <- subset(Prrx1.periosteum, idents = c("0","1"))        # Subset seurat by cells to include
Idents(u) <- "Age_Diet"
u <- subset(u, idents = c("Young_Ad libitum","Adult_Ad libitum","Aged_Ad libitum"))
umap_coords <- as.data.frame(u[["umap"]]@cell.embeddings)    # Save UMAP y-coordinate as dataframe
u$UMAP_2 <- umap_coords$UMAP_2                          # Add UMAP y-coord as seurat object metadata
top_cells <- rownames(umap_coords[umap_coords$UMAP_2 > 3,])      # Find top cell names
bottom_cells <- rownames(umap_coords[umap_coords$UMAP_2 < 3,])   # Find bottom cell names
Idents(object = u, cells = top_cells) <- "top"                # Add top as ident to these cells in seurat object
Idents(object = u, cells = bottom_cells) <- "bottom"         # Add bottom as ident to these cells in seurat object
u$umap_group <- Idents(u)                            # Save idents as new metadata slot
DimPlot(u, group.by = "umap_group", split.by = "Age_Diet")           # DimPlot object

library(dplyr)
library(data.table)
md <- u@meta.data %>% as.data.table
# the resulting md object has one "row" per cell
## count the number of cells per unique combinations of "Sample" and "seurat_clusters"
cell_table <- md[, .N, by = c("Age_Diet", "umap_group")]

PeriosteumBottomvsTop <- FindMarkers(u, ident.1 = "bottom", ident.2 = "top", verbose = TRUE)
library(openxlsx)
write.xlsx(PeriosteumBottomvsTop, "PeriosteumBottomvsTop.xlsx",sheetName="Data", colNames=T,rowNames=T,showNA = F, Append = TRUE)

u$umap_group
u$UMAP_2
u$seurat_clusters
saveRDS(u, "Periosteum clusters 0 and 1.rds")

